function [crowdingDistance]=CrowdingDistance(VFO,F)

crowdingDistance=zeros(length(F),1);

numRank = unique(F);

% Crowding distances for the solutions of each Front i (Fi)
for i = numRank'

    Fi = (F == i);
    
    VFOi=VFO(Fi,:); 
    
    popSize = size(VFOi,1);
    
    numData = size(VFOi,2);
    
    CDi = zeros(popSize,1);
    
    for m = 1:numData
        data = VFOi(:,m);

        %sorting
        [~,in] = sort(data);
        
        % The best and worst individuals are at the end of Pareto front and
        % they are assigned Inf distance measure
        CDi([in(1),in(end)]) = inf;
        % Distance measure of remaining individuals (normalizada)
        j = 2;
        while j < popSize
            CDi(in(j)) = CDi(in(j)) + min(Inf, (data(in(j+1)) - data(in(j-1))))/(data(in(end))-data(in(1)));
            j = j+1;
        end
    end
    crowdingDistance(Fi)=CDi;
end
end